<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\Service\Security;

use IssetBV\MyIsset\CoreBundle\Service\Data\MyIssetUrlProviderInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;

class UserLogout
{
    /**
     * @var TokenStorageInterface
     */
    private $tokenStorage;
    /**
     * @var RememberMe
     */
    private $rememberMe;
    /**
     * @var MyIssetUrlProviderInterface
     */
    private $myIssetUrlProvider;

    public function __construct(
        TokenStorageInterface $tokenStorage,
        MyIssetUrlProviderInterface $myIssetUrlProvider,
        RememberMe $rememberMe
    ) {
        $this->tokenStorage = $tokenStorage;
        $this->rememberMe = $rememberMe;
        $this->myIssetUrlProvider = $myIssetUrlProvider;
    }

    public function logoutMyIsset(TokenInterface $token, Request $request, string $returnUrl): Response
    {
        $url = $this->myIssetUrlProvider->getLogoutUrl($returnUrl);

        return $this->logoutToUrl($token, $request, $url);
    }

    public function logoutLocal(TokenInterface $token, Request $request, string $returnUrl): Response
    {
        return $this->logoutToUrl($token, $request, $returnUrl);
    }

    public function logoutToUrl(TokenInterface $token, Request $request, string $url): Response
    {
        $this->tokenStorage->setToken();
        $session = $request->getSession();

        if (null !== $session) {
            $session->invalidate();
        }

        $response = new RedirectResponse($url);
        $this->rememberMe->logout($token, $request, $response);

        return $response;
    }
}
