<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\Service\Security;

use IssetBV\MyIsset\OAuthBundle\Service\Client\Data\LoginToken;
use IssetBV\MyIsset\OAuthBundle\Service\Client\Exception\TokenNotCreatedException;

class UserLoginToken
{
    /**
     * @var UserLoginTokenGenerator
     */
    private $loginTokenGenerator;
    /**
     * @var string
     */
    private $publicKey;
    /**
     * @var string
     */
    private $privateKey;

    /**
     * UserLoginToken constructor.
     *
     * @param UserLoginTokenGenerator $loginTokenGenerator
     * @param string $publicKey
     * @param string $privateKey
     */
    public function __construct(UserLoginTokenGenerator $loginTokenGenerator, string $publicKey, string $privateKey)
    {
        $this->loginTokenGenerator = $loginTokenGenerator;
        $this->publicKey = $publicKey;
        $this->privateKey = $privateKey;
    }

    /**
     * @throws TokenNotCreatedException
     *
     * @return LoginToken
     */
    public function generate(): LoginToken
    {
        return $this->loginTokenGenerator->generate($this->publicKey, $this->privateKey);
    }
}
