<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle;

use IssetBV\MyIsset\OAuthBundle\DependencyInjection\MyIssetOAuthExtension;
use IssetBV\MyIsset\OAuthBundle\Service\Security\RememberMe\RememberMeFactory;
use Symfony\Bundle\SecurityBundle\DependencyInjection\SecurityExtension;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\Bundle\Bundle;

class IssetBVMyIssetOAuthBundle extends Bundle
{
    public function getContainerExtension()
    {
        return new MyIssetOAuthExtension();
    }

    public function build(ContainerBuilder $container)
    {
        parent::build($container);

        $extension = $container->getExtension('security');
        if ($extension instanceof SecurityExtension) {
            $extension->addSecurityListenerFactory(new RememberMeFactory());
        }
    }
}
