<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\Service\Security;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\RouterInterface;

class ReturnUrlGenerator
{
    /**
     * @var RouterInterface
     */
    private $router;
    /**
     * @var string|null
     */
    private $baseRoute;

    public function __construct(RouterInterface $router, string $baseRoute = null)
    {
        $this->router = $router;
        $this->baseRoute = $baseRoute;
    }

    /**
     * @param Request $request
     *
     * @throws \Symfony\Component\Routing\Exception\RouteNotFoundException
     * @throws \Symfony\Component\Routing\Exception\MissingMandatoryParametersException
     * @throws \Symfony\Component\Routing\Exception\InvalidParameterException
     *
     * @return string
     */
    public function generateFor(Request $request): string
    {
        if ($request->query->get('return_url')) {
            return $request->query->get('return_url');
        }

        if (null !== $this->baseRoute) {
            return $this->router->generate($this->baseRoute);
        }

        return $request->getUriForPath($request->getBaseUrl());
    }
}
