<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\Service\Security\RememberMe;

use DateTime;
use Doctrine\Common\Persistence\ObjectManager;
use IssetBV\MyIsset\OAuthBundle\Entity\RememberMeToken;
use IssetBV\MyIsset\OAuthBundle\Repository\RememberMeTokenRepository;

class TokenProvider
{
    /**
     * @var RememberMeTokenRepository
     */
    private $rememberMeRepository;
    /**
     * @var ObjectManager
     */
    private $objectManager;

    public function __construct(ObjectManager $objectManager, RememberMeTokenRepository $rememberMeRepository)
    {
        $this->rememberMeRepository = $rememberMeRepository;
        $this->objectManager = $objectManager;
    }

    public function provideFor(string $apiKey, DateTime $expires): RememberMeToken
    {
        $rememberMeToken = new RememberMeToken($apiKey, $expires);
        $this->objectManager->persist($rememberMeToken);
        $this->objectManager->flush();

        return $rememberMeToken;
    }

    /**
     * @param string $token
     *
     * @return RememberMeToken|null
     */
    public function fetchByToken(string $token)
    {
        $rememberMeToken = $this->rememberMeRepository->findOneBy(['token' => $token]);
        if (null === $rememberMeToken || !($rememberMeToken instanceof RememberMeToken)) {
            return null;
        }

        if ($rememberMeToken->isExpired()) {
            $this->objectManager->remove($rememberMeToken);
            $this->objectManager->flush();

            return null;
        }

        return $rememberMeToken;
    }
}
