<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\DependencyInjection;

use IssetBV\MyIsset\CoreBundle\DependencyInjection\ConfigurationAddInterface;
use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\NodeBuilder;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface, ConfigurationAddInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root($this->getRootNode());
        $children = $rootNode->children();
        $this->addConfig($children);
        $children->end();

        return $treeBuilder;
    }

    public function addToNode(ArrayNodeDefinition $nodeDefinition)
    {
        $node = $nodeDefinition
            ->children()
            ->arrayNode($this->getNode())
            ->isRequired()
            ->children();

        $this->addConfig($node);

        $node->end()
            ->end()
            ->end();
    }

    public function getNode(): string
    {
        return 'oauth';
    }

    public function getRootNode(): string
    {
        return 'myisset_oauth';
    }

    private function addConfig(NodeBuilder $node)
    {
        $node->scalarNode('public_key')->isRequired()->end();
        $node->scalarNode('private_key')->isRequired()->end();
        $node->scalarNode('token')->defaultValue('token')->end();
        $node->scalarNode('route_default')->defaultNull()->end();
        $node->scalarNode('route_error')->defaultValue('isset_bv_my_isset_o_auth_error')->end();
    }
}
