<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('myisset_oauth');
        $rootNode
            ->children()
            ->scalarNode('public_key')->isRequired()->end()
            ->scalarNode('private_key')->isRequired()->end()
            ->scalarNode('token')->defaultValue('token')->end()
            ->scalarNode('route_default')->defaultNull()->end()
            ->scalarNode('route_error')->defaultValue('isset_bv_my_isset_o_auth_error')->end()
            ->end();

        return $treeBuilder;
    }
}
