<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\Service\Security;

use IssetBV\MyIsset\OAuthBundle\Service\Client\Client;
use IssetBV\MyIsset\OAuthBundle\Service\Client\Data\LoginToken;
use IssetBV\MyIsset\OAuthBundle\Service\Client\Exception\TokenNotCreatedException;
use Symfony\Component\Security\Core\Encoder\EncoderFactoryInterface;
use Symfony\Component\Security\Core\Encoder\PasswordEncoderInterface;

class UserLoginTokenGenerator
{
    /**
     * @var PasswordEncoderInterface
     */
    private $passwordEncoder;
    /**
     * @var Client
     */
    private $client;

    /**
     * UserLoginTokenGenerator constructor.
     *
     * @param EncoderFactoryInterface $encoderFactory
     * @param Client $client
     */
    public function __construct(EncoderFactoryInterface $encoderFactory, Client $client)
    {
        $this->passwordEncoder = $encoderFactory->getEncoder(self::class);
        $this->client = $client;
    }

    /**
     * @param string $publicKey
     * @param string $privateKey
     *
     * @throws TokenNotCreatedException
     *
     * @return LoginToken
     */
    public function generate(string $publicKey, string $privateKey): LoginToken
    {
        $time = time() . '_' . sha1(random_int(0, PHP_INT_MAX) . microtime() . uniqid('_', true));
        $hash = $this->passwordEncoder->encodePassword($publicKey . $privateKey . $time, $time);

        return $this->client->getLoginToken($publicKey, $time, $hash);
    }
}
