<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\DependencyInjection;

use IssetBV\MyIsset\OAuthBundle\Service\Security\ReturnUrlGenerator;
use IssetBV\MyIsset\OAuthBundle\Service\Security\UserAuthenticator;
use IssetBV\MyIsset\OAuthBundle\Service\Security\UserLoginError;
use IssetBV\MyIsset\OAuthBundle\Service\Security\UserLoginToken;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class MyIssetOAuthExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');
        $loader->load('security.yml');

        $definition = $container->register(UserLoginToken::class);
        $definition->setAutowired(true);
        $definition->setArgument('$publicKey', $config['public_key']);
        $definition->setArgument('$privateKey', $config['private_key']);

        $definition = $container->register(UserAuthenticator::class);
        $definition->setAutowired(true);
        $definition->setArgument('$tokenName', $config['token']);

        $definition = $container->register(ReturnUrlGenerator::class);
        $definition->setAutowired(true);
        $definition->setArgument('$baseRoute', $config['route_default']);

        $definition = $container->register(UserLoginError::class);
        $definition->setAutowired(true);
        $definition->setArgument('$route', $config['route_error']);
    }

    public function getAlias(): string
    {
        return 'myisset_oauth';
    }
}
