<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\Controller;

use IssetBV\MyIsset\OAuthBundle\Service\Security\UserLogin;
use IssetBV\MyIsset\OAuthBundle\Service\Security\UserLogout;
use Psr\Log\LoggerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;

class AuthenticationController extends Controller
{
    public function loginAction(Request $request, UserLogin $userLogin)
    {
        if (null !== $this->getUser()) {
            return $this->redirectToRoute('isset_bv_my_isset_o_auth_logout');
        }

        return $userLogin->login($request);
    }

    public function logoutMyIssetAction(Request $request, UserLogout $userLogout, TokenStorageInterface $tokenStorage)
    {
        $token = $tokenStorage->getToken();
        if (null === $token) {
            return $this->redirectToRoute('isset_bv_my_isset_o_auth_login');
        }

        $returnUrl = $this->generateUrl('isset_bv_my_isset_o_auth_login', [], UrlGeneratorInterface::ABSOLUTE_URL);

        return $userLogout->logoutMyIsset($token, $request, $returnUrl);
    }

    public function logoutLocalAction(Request $request, UserLogout $userLogout, TokenStorageInterface $tokenStorage)
    {
        $token = $tokenStorage->getToken();
        if (null === $token) {
            return $this->redirectToRoute('isset_bv_my_isset_o_auth_login');
        }

        $returnUrl = $this->generateUrl('isset_bv_my_isset_o_auth_login');

        return $userLogout->logoutLocal($token, $request, $returnUrl);
    }

    public function callbackAction()
    {
        $returnUrl = $this->generateUrl('isset_bv_my_isset_o_auth_error', []);

        return $this->redirect($returnUrl);
    }

    public function errorAction(LoggerInterface $logger)
    {
        $logger->error('Login encountered errors');

        return new Response('', 500);
    }
}
