<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\Service\Security;

use IssetBV\MyIsset\CoreBundle\Service\Data\MyIssetUrlProviderInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;

class UserLogout
{
    /**
     * @var TokenStorageInterface
     */
    private $tokenStorage;
    /**
     * @var RememberMe|null
     */
    private $rememberMe;
    /**
     * @var MyIssetUrlProviderInterface
     */
    private $myIssetUrlProvider;

    /**
     * UserLogout constructor.
     *
     * @param TokenStorageInterface $tokenStorage
     * @param RememberMe $rememberMe
     * @param MyIssetUrlProviderInterface $myIssetUrlProvider
     */
    public function __construct(
        TokenStorageInterface $tokenStorage,
        MyIssetUrlProviderInterface $myIssetUrlProvider,
        RememberMe $rememberMe = null
    ) {
        $this->tokenStorage = $tokenStorage;
        $this->rememberMe = $rememberMe;
        $this->myIssetUrlProvider = $myIssetUrlProvider;
    }

    /**
     * @param Request $request
     * @param string $returnUrl
     *
     * @return Response
     */
    public function logoutMyIsset(Request $request, string $returnUrl): Response
    {
        $url = $this->myIssetUrlProvider->getLogoutUrl($returnUrl);

        return $this->logoutToUrl($request, $url);
    }

    /**
     * @param Request $request
     * @param string $returnUrl
     *
     * @return Response
     */
    public function logoutLocal(Request $request, string $returnUrl): Response
    {
        return $this->logoutToUrl($request, $returnUrl);
    }

    public function logoutToUrl(Request $request, string $url): Response
    {
        $this->tokenStorage->setToken();
        $session = $request->getSession();

        if (null !== $session) {
            $session->invalidate();
        }

        $response = new RedirectResponse($url);
        if (null !== $this->rememberMe) {
            $response->headers->clearCookie($this->rememberMe->getName());
        }

        return $response;
    }
}
