<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\Controller;

use IssetBV\MyIsset\OAuthBundle\Service\Security\UserLogin;
use IssetBV\MyIsset\OAuthBundle\Service\Security\UserLogout;
use Psr\Log\LoggerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

class AuthenticationController extends Controller
{
    public function loginAction(Request $request, UserLogin $userLogin)
    {
        return $userLogin->login($request);
    }

    public function logoutMyIssetAction(Request $request, UserLogout $userLogout)
    {
        $returnUrl = $this->generateUrl('isset_bv_my_isset_o_auth_login', [], UrlGeneratorInterface::ABSOLUTE_URL);

        return $userLogout->logoutMyIsset($request, $returnUrl);
    }

    public function logoutLocalAction(Request $request, UserLogout $userLogout)
    {
        $returnUrl = $this->generateUrl('isset_bv_my_isset_o_auth_login');

        return $userLogout->logoutLocal($request, $returnUrl);
    }

    public function callbackAction()
    {
        $returnUrl = $this->generateUrl('isset_bv_my_isset_o_auth_error', []);

        return $this->redirect($returnUrl);
    }

    public function errorAction(LoggerInterface $logger)
    {
        $logger->error('Login encountered errors');

        return new Response('', 500);
    }
}
