<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\Service\Security;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Core\User\UserProviderInterface;
use Symfony\Component\Security\Http\RememberMe\TokenBasedRememberMeServices;

class RememberMe
{
    /**
     * @var string
     */
    private $path;
    /**
     * @var string
     */
    private $name;
    /**
     * @var string
     */
    private $domain;
    /**
     * @var bool
     */
    private $secure;
    /**
     * @var bool
     */
    private $httpOnly;
    /**
     * @var int
     */
    private $lifeTime;
    /**
     * @var string
     */
    private $secret;

    /**
     * UserRememberMe constructor.
     *
     * @param string $path
     * @param string $name
     * @param string $domain
     * @param bool $secure
     * @param bool $httpOnly
     * @param int $lifeTime
     * @param string $secret
     */
    public function __construct(
        string $path,
        string $name,
        string $domain = null,
        bool $secure,
        bool $httpOnly,
        int $lifeTime,
        string $secret
    ) {
        $this->path = $path;
        $this->name = $name;
        $this->domain = $domain;
        $this->secure = $secure;
        $this->httpOnly = $httpOnly;
        $this->lifeTime = $lifeTime;
        $this->secret = $secret;
    }

    public function addRememberMe(
        Response $response,
        Request $request,
        TokenInterface $token,
        UserProviderInterface $userProviderInterface
    ) {
        $rememberMeService = new TokenBasedRememberMeServices([
            $userProviderInterface,
        ], $this->secret, $token->getProviderKey(), [
            'path' => $this->path,
            'name' => $this->name,
            'domain' => $this->domain,
            'secure' => $this->secure,
            'httponly' => $this->httpOnly,
            'lifetime' => $this->lifeTime, // 14 days
            'always_remember_me' => true,
            'remember_me_parameter' => '_remember_me',
        ]);
        $rememberMeService->loginSuccess($request, $response, $token);
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }
}
