<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\Service\Security;

use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Core\User\UserProviderInterface;

class AuthenticationSuccessHandler
{
    /**
     * @var RememberMe
     */
    private $userRememberMe;
    /**
     * @var ReturnUrlGenerator
     */
    private $returnUrlGenerator;

    /**
     * UserAuthenticationSuccessHandler constructor.
     *
     * @param RememberMe $userRememberMe
     * @param ReturnUrlGenerator $returnUrlGenerator
     */
    public function __construct(ReturnUrlGenerator $returnUrlGenerator, RememberMe $userRememberMe = null)
    {
        $this->userRememberMe = $userRememberMe;
        $this->returnUrlGenerator = $returnUrlGenerator;
    }

    /**
     * @param Request $request
     * @param TokenInterface $token
     * @param UserProviderInterface $userProviderInterface
     *
     * @throws \InvalidArgumentException
     *
     * @return Response
     */
    public function handle(Request $request, TokenInterface $token, UserProviderInterface $userProviderInterface): Response
    {
        $url = $this->returnUrlGenerator->generateFor($request);
        $response = new RedirectResponse($url);
        if (null !== $this->userRememberMe && null !== $request->query->get('remember_me')) {
            $this->userRememberMe->addRememberMe($response, $request, $token, $userProviderInterface);
        }

        return $response;
    }
}
