<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\Service\Client;

use IssetBV\MyIsset\CoreBundle\Service\Data\MyIssetUrlProvider;

class OAuthUrlProvider
{
    /**
     * @var MyIssetUrlProvider
     */
    private $urlProvider;

    public function __construct(MyIssetUrlProvider $urlProvider)
    {
        $this->urlProvider = $urlProvider;
    }

    public function createLoginTokenUrl(string $publicKey, string $time, string $hash): string
    {
        return sprintf(
            '%sapi/oauth/token/login?platform=%s&time=%s&hash=%s',
            $this->urlProvider->getBaseUrl(),
            urlencode($publicKey),
            urlencode($time),
            urlencode($hash)
        );
    }

    public function createAccountUrl(): string
    {
        return sprintf(
            '%sapi/oauth/account',
            $this->urlProvider->getBaseUrl()
        );
    }
}
