<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\OAuthBundle\Service\Security;

use IssetBV\MyIsset\CoreBundle\Service\Data\MyIssetUrlProviderInterface;
use IssetBV\MyIsset\OAuthBundle\Service\Client\Exception\TokenNotCreatedException;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\Routing\RouterInterface;

class UserLogin
{
    /**
     * @var RouterInterface
     */
    private $router;
    /**
     * @var UserLoginToken
     */
    private $userLoginToken;
    /**
     * @var UserLoginError
     */
    private $userLoginError;
    /**
     * @var MyIssetUrlProviderInterface
     */
    private $myIssetUrlProvider;

    public function __construct(
        RouterInterface $router,
        MyIssetUrlProviderInterface $myIssetUrlProvider,
        UserLoginToken $userLoginToken,
        UserLoginError $userLoginError
    ) {
        $this->router = $router;
        $this->userLoginToken = $userLoginToken;
        $this->userLoginError = $userLoginError;
        $this->myIssetUrlProvider = $myIssetUrlProvider;
    }

    public function login(Request $request): Response
    {
        $returnUrl = $this->getUrl($request);
        $callback = $this->router->generate(
            'isset_bv_my_isset_o_auth_callback',
            ['return_url' => $returnUrl],
            UrlGeneratorInterface::ABSOLUTE_URL
        );

        try {
            $token = $this->userLoginToken->generate();

            $url = $this->myIssetUrlProvider->getLoginUrl($token->getToken(), '1', $callback);
        } catch (TokenNotCreatedException $e) {
            $url = $this->userLoginError->requestExceptionToErrorUrl($e);
        }

        return new RedirectResponse($url);
    }

    private function getUrl(Request $request)
    {
        $attributes = $request->getSession()->all();

        foreach ($attributes as $key => $value) {
            if (false !== mb_strpos($key, '_security') && false !== mb_strpos($key, 'target_path')) {
                return $value;
            }
        }

        return $request->getBaseUrl();
    }
}
