<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\OAuthBundle\Service\Security;

use IssetBV\MyIsset\CoreBundle\Service\Client\Core\RequestException;
use Psr\Log\LoggerInterface;
use Symfony\Component\Routing\RouterInterface;

class UserLoginError
{

    /**
     * @var RouterInterface
     */
    private $router;
    /**
     * @var LoggerInterface
     */
    private $logger;
    /**
     * @var string
     */
    private $route;

    /**
     * UserLoginError constructor.
     * @param RouterInterface $router
     * @param LoggerInterface $logger
     * @param string $route
     */
    public function __construct(RouterInterface $router, LoggerInterface $logger, string $route)
    {
        $this->router = $router;
        $this->logger = $logger;
        $this->route = $route;
    }

    public function requestExceptionToErrorUrl(RequestException $e): string
    {
        $this->logger->error($e->getMessage());
        $errorData = ['error_code' => ''];
        $httpCode = $e->getHttpCode();
        if ($httpCode >= 500) {
            $errorData['error_code'] = 'myisset_down';
        } elseif ($httpCode >= 400) {
            $errorData['error_code'] = 'myisset_bad_request';
        } else {
            $errorData['error_code'] = 'myisset_unknown';
        }

        return $this->router->generate($this->route, $errorData);
    }
}