<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\OAuthBundle\Service\Security;

use IssetBV\MyIsset\CoreBundle\Service\Client\Core\RequestException;
use IssetBV\MyIsset\CoreBundle\Service\Data\MyIsset;
use Psr\Log\LoggerInterface;
use Symfony\Bridge\Monolog\Logger;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\Routing\RouterInterface;

class UserLogin
{

    /**
     * @var RouterInterface
     */
    private $router;
    /**
     * @var MyIsset
     */
    private $myIsset;
    /**
     * @var UserLoginToken
     */
    private $userLoginToken;
    /**
     * @var UserLoginError
     */
    private $userLoginError;

    /**
     * UserLogin constructor.
     * @param RouterInterface $router
     * @param MyIsset $myIsset
     * @param UserLoginToken $userLoginToken
     * @param UserLoginError $userLoginError
     */
    public function __construct(RouterInterface $router, MyIsset $myIsset, UserLoginToken $userLoginToken, UserLoginError $userLoginError)
    {
        $this->router = $router;
        $this->myIsset = $myIsset;
        $this->userLoginToken = $userLoginToken;
        $this->userLoginError = $userLoginError;
    }

    /**
     * @param Request $request
     * @return Response
     */
    public function login(Request $request): Response
    {
        $returnUrl = $this->getUrl($request);
        $data = ['return_url' => $returnUrl];
        $callback = $this->router->generate('isset_bv_my_isset_o_auth_callback', $data, UrlGeneratorInterface::ABSOLUTE_URL);
        try {
            $token = $this->userLoginToken->generate();

            $url = $this->myIsset->getLoginUrl($token->getToken(), '1', $callback);
        } catch (RequestException $e) {
            $url = $this->userLoginError->requestExceptionToErrorUrl($e);

        }
        return new RedirectResponse($url);
    }

    private function getUrl(Request $request)
    {
        $attributes = $request->getSession()->all();

        foreach ($attributes as $key => $value) {
            if (strpos($key, '_security') !== false && strpos($key, 'target_path') !== false) {
                return $value;
            }
        }

        return $request->getBaseUrl();
    }
}