<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\OAuthBundle\Service\Security;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\RouterInterface;

class ReturnUrlGenerator
{

    /**
     * @var RouterInterface
     */
    private $router;
    /**
     * @var string
     */
    private $secret;
    private $baseRoute;

    /**
     * ReturnUrlGenerator constructor.
     * @param RouterInterface $router
     * @param string $secret
     * @param $baseRoute
     */
    public function __construct(RouterInterface $router, string $secret, $baseRoute)
    {
        $this->router = $router;
        $this->secret = $secret;
        $this->baseRoute = $baseRoute;
    }

    /**
     * @param Request $request
     * @return string
     * @throws \Symfony\Component\Routing\Exception\RouteNotFoundException
     * @throws \Symfony\Component\Routing\Exception\MissingMandatoryParametersException
     * @throws \Symfony\Component\Routing\Exception\InvalidParameterException
     */
    public function generateFor(Request $request): string
    {
        if ($request->query->get('return_url')) {
            return $request->query->get('return_url');
        } elseif ($this->baseRoute !== null) {
            return $this->router->generate($this->baseRoute);
        } else {
            return $request->getUriForPath($request->getBaseUrl());
        }
}