<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\OAuthBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

class AuthenticationController extends Controller
{

    public function loginAction(Request $request)
    {
        return $this->get('isset_bv_my_isset_o_auth.security.user.login')->login($request);
    }

    public function logoutMyIssetAction(Request $request)
    {
        $returnUrl = $this->generateUrl('isset_bv_my_isset_o_auth_login', [], UrlGeneratorInterface::ABSOLUTE_URL);
        return $this->get('isset_bv_my_isset_o_auth.security.user.logout')->logoutMyIsset($request, $returnUrl);
    }

    public function logoutLocalAction(Request $request)
    {
        $returnUrl = $this->generateUrl('isset_bv_my_isset_o_auth_login');
        return $this->get('isset_bv_my_isset_o_auth.security.user.logout')->logoutLocal($request, $returnUrl);
    }

    public function callbackAction(Request $request)
    {
        $returnUrl = $this->generateUrl('isset_bv_my_isset_o_auth_error', []);
        return $this->redirect($returnUrl);
    }

    public function errorAction()
    {
        die('login errors');
    }
}