<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\OAuthBundle\Service\Security;

use IssetBV\MyIsset\CoreBundle\Service\Data\MyIsset;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;

class UserLogout
{

    /**
     * @var TokenStorageInterface
     */
    private $tokenStorage;
    /**
     * @var RememberMe
     */
    private $rememberMe;
    /**
     * @var MyIsset
     */
    private $myIsset;

    /**
     * UserLogout constructor.
     * @param TokenStorageInterface $tokenStorage
     * @param RememberMe $rememberMe
     * @param MyIsset $myIsset
     */
    public function __construct(
        TokenStorageInterface $tokenStorage,
        RememberMe $rememberMe,
        MyIsset $myIsset
    ) {
        $this->tokenStorage = $tokenStorage;
        $this->rememberMe = $rememberMe;
        $this->myIsset = $myIsset;
    }

    /**
     * @param Request $request
     * @param string $returnUrl
     * @return Response
     */
    public function logoutMyIsset(Request $request, string $returnUrl): Response
    {
        $this->tokenStorage->setToken(null);
        $request->getSession()->invalidate();
        $response = new RedirectResponse($this->myIsset->getLogoutUrl($returnUrl));
        $this->rememberMe->clear($response);
        return $response;
    }

    /**
     * @param Request $request
     * @param string $returnUrl
     * @return RedirectResponse
     */
    public function logoutLocal(Request $request, string $returnUrl)
    {
        $this->tokenStorage->setToken(null);
        $request->getSession()->invalidate();
        $response = new RedirectResponse($returnUrl);
        $this->rememberMe->clear($response);
        return $response;

    }
}