<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\OAuthBundle\Service\Client;

use IssetBV\MyIsset\CoreBundle\Service\Client\Core\Client as CoreClient;
use IssetBV\MyIsset\CoreBundle\Service\Client\Core\Request;
use IssetBV\MyIsset\CoreBundle\Service\Client\Core\RequestException;
use IssetBV\MyIsset\CoreBundle\Service\Security\ClientData\ClientData;
use IssetBV\MyIsset\CoreBundle\Service\Security\ClientData\ClientDataDivision;
use IssetBV\MyIsset\CoreBundle\Service\Security\Exception\AccountNotFound;
use IssetBV\MyIsset\CoreBundle\Service\Security\UserProviderClient;
use IssetBV\MyIsset\CoreBundle\Service\Security\UserProviderClientData;
use IssetBV\MyIsset\OAuthBundle\Service\Client\Data\LoginToken;

class Client implements UserProviderClient
{

    /**
     * @var CoreClient
     */
    private $client;

    /**
     * Client constructor.
     * @param CoreClient $client
     */
    public function __construct(CoreClient $client)
    {
        $this->client = $client;
    }

    /**
     * @param string $token
     * @return UserProviderClientData
     * @throws AccountNotFound
     */
    public function getAccount(string $token): UserProviderClientData
    {

        $request = new Request('GET', 'api/oauth/account', ['x-mijn-isset' => $token]);
        try {
            $response = $this->client->call($request);
            $data = json_decode($response->getBody()->getContents());
            $divisions = [];
            foreach ($data->divisions as $divisionData) {
                $divisions[] = new ClientDataDivision($divisionData->uuid, $divisionData->name);
            }
            $currentDivision = new ClientDataDivision($data->division_current->uuid, $data->division_current->name);
            return new ClientData($data->account_uuid, $data->owner_uuid, $data->username, $data->email, $data->roles, $divisions,
                $currentDivision);
        } catch (RequestException $e) {
            throw new AccountNotFound('Account not found', 0, $e);
        }
    }

    /**
     * @param string $publicKey
     * @param string $time
     * @param string $hash
     * @return LoginToken
     * @throws \IssetBV\MyIsset\CoreBundle\Service\Client\Core\RequestException
     */
    public function getLoginToken(string $publicKey, string $time, string $hash): LoginToken
    {
        $url = sprintf('api/oauth/token/login?platform=%s&time=%s&hash=%s', urlencode($publicKey), urlencode($time), urlencode($hash));
        $request = new Request('GET', $url);
        $response = $this->client->call($request);
        $data = json_decode($response->getBody()->getContents());
        if (!isset($data->login_token)) {
            die('error');
        }
        return new LoginToken($data->login_token);
    }
}