<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\CoreBundle\Service\Security\ClientData;

use IssetBV\MyIsset\CoreBundle\Service\Security\ClientDataInterface;
use IssetBV\MyIsset\CoreBundle\Service\Security\Exception\AccountNotFound;
use Psr\Http\Message\ResponseInterface;

class ClientDataGenerator
{
    /**
     * @param ResponseInterface $response
     *
     * @throws AccountNotFound
     *
     * @return ClientDataInterface
     */
    public function fromResponse(ResponseInterface $response): ClientDataInterface
    {
        if (200 !== $response->getStatusCode()) {
            throw AccountNotFound::create('account not found');
        }

        return $this->fromString((string) $response->getBody());
    }

    /**
     * @param string $body
     *
     * @return ClientDataInterface
     */
    public function fromString(string $body): ClientDataInterface
    {
        $data = json_decode($body);
        $divisions = [];

        foreach ($data->divisions as $divisionData) {
            $divisions[] = new ClientDataDivision($divisionData->uuid, $divisionData->name);
        }
        $currentDivision = new ClientDataDivision($data->division_current->uuid, $data->division_current->name);
        $owner = new ClientDataOwner($data->owner->uuid, $data->owner->name);

        return new ClientData(
            $data->account_uuid,
            $data->username,
            $data->email,
            $data->roles,
            $divisions,
            $currentDivision,
            $owner
        );
    }
}
