<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\CoreBundle\DependencyInjection;

use IssetBV\MyIsset\CoreBundle\Service\Data\MyIssetUrlProvider;
use IssetBV\MyIsset\CoreBundle\Service\Data\MyIssetUrlProviderInterface;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class MyIssetCoreExtension extends Extension implements PrependExtensionInterface
{
    /**
     * @var Configuration
     */
    private $configuration;

    public function prepend(ContainerBuilder $container)
    {
        $this->configuration = new Configuration();
        $bundles = $container->getParameter('kernel.bundles');

        foreach ($bundles as $key => $value) {
            if (false === mb_strpos($key, 'IssetBVMyIsset')) {
                continue;
            }
            if (false !== mb_strpos($key, 'CoreBundle')) {
                continue;
            }
            $className = str_replace($key, '', $value) . 'DependencyInjection\\Configuration';
            $class = new $className();
            if ($class instanceof ConfigurationAddInterface) {
                $this->configuration->addConfiguration($class);
            }
        }

        $configs = $container->getExtensionConfig($this->getAlias());

        $configMerged = \array_merge(...$configs);

        foreach ($this->configuration->getConfigs() as $config) {
            $value = null;
            if (array_key_exists($config->getNode(), $configMerged)) {
                $value = $configMerged[$config->getNode()];
            }

            $container->prependExtensionConfig($config->getRootNode(), $value ?? []);
        }
    }

    public function load(array $configs, ContainerBuilder $container)
    {
        $config = $this->processConfiguration($this->configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        $baseUrl = $config['myisset_url'];

        $definition = $container->register(MyIssetUrlProvider::class);
        $definition->setAutowired(true);
        $definition->setArgument('$baseUrl', $baseUrl);

        $container->setAlias(MyIssetUrlProviderInterface::class, MyIssetUrlProvider::class);
    }

    public function getAlias(): string
    {
        return 'myisset';
    }
}
