<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\CoreBundle\Service\Security;

interface ClientDataInterface
{
    /**
     * @return string
     */
    public function getUuid(): string;

    /**
     * @return string
     */
    public function getName(): string;

    /**
     * @return string
     */
    public function getEmail(): string;

    /**
     * @return array
     */
    public function getRoles(): array;

    /**
     * @return ClientDataDivisionInterface[]
     */
    public function getDivisions(): array;

    /**
     * @return ClientDataDivisionInterface
     */
    public function getCurrentDivisionUuid(): ClientDataDivisionInterface;

    /**
     * @return ClientDataOwnerInterface
     */
    public function getOwner(): ClientDataOwnerInterface;
}
