<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\CoreBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    /**
     * @var ConfigurationAddInterface[]
     */
    private $configs = [];

    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('myisset');

        $rootNode->children()
            ->scalarNode('myisset_url')->defaultValue('https://my.isset.net/')->end()
            ->end();

        foreach ($this->configs as $config) {
            $config->addToNode($rootNode);
        }

        return $treeBuilder;
    }

    public function addConfiguration(ConfigurationAddInterface $configurationAdd)
    {
        $this->configs[] = $configurationAdd;
    }

    /**
     * @return ConfigurationAddInterface[]
     */
    public function getConfigs(): array
    {
        return $this->configs;
    }
}
