<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\CoreBundle\Service\Data;

interface MyIssetUrlProviderInterface
{
    /**
     * @return string
     */
    public function getBaseUrl(): string;

    public function getWithBaseUrl(string $part): String;

    /**
     * @param string $loginToken
     * @param string $view
     * @param string $returnUrl
     *
     * @return string
     */
    public function getLoginUrl(string $loginToken, string $view, string $returnUrl): string;

    /**
     * @param string $returnUrl
     *
     * @return string
     */
    public function getLogoutUrl(string $returnUrl): string;
}
