<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\CoreBundle\Service\Security\ClientData;

use IssetBV\MyIsset\CoreBundle\Service\Security\ClientDataDivisionInterface;
use IssetBV\MyIsset\CoreBundle\Service\Security\ClientDataInterface;
use IssetBV\MyIsset\CoreBundle\Service\Security\ClientDataOwnerInterface;

class ClientData implements ClientDataInterface
{
    /**
     * @var string
     */
    private $uuid;
    /**
     * @var string
     */
    private $ownerUuid;
    /**
     * @var string
     */
    private $name;
    /**
     * @var string
     */
    private $email;
    /**
     * @var array
     */
    private $roles;
    /**
     * @var array
     */
    private $divisions;
    /**
     * @var ClientDataDivisionInterface
     */
    private $currentDivisionUuid;
    /**
     * @var ClientDataOwnerInterface
     */
    private $clientDataOwner;

    /**
     * ClientData constructor.
     *
     * @param string $uuid
     * @param string $name
     * @param string $email
     * @param array $roles
     * @param array $divisions
     * @param ClientDataDivisionInterface $currentDivisionUuid
     * @param ClientDataOwnerInterface $clientDataOwner
     */
    public function __construct(
        string $uuid,
        string $name,
        string $email,
        array $roles,
        array $divisions,
        ClientDataDivisionInterface $currentDivisionUuid,
        ClientDataOwnerInterface $clientDataOwner
    ) {
        $this->uuid = $uuid;
        $this->name = $name;
        $this->email = $email;
        $this->roles = $roles;
        $this->divisions = $divisions;
        $this->currentDivisionUuid = $currentDivisionUuid;
        $this->clientDataOwner = $clientDataOwner;
    }

    /**
     * @return string
     */
    public function getUuid(): string
    {
        return $this->uuid;
    }

    /**
     * @return string
     */
    public function getOwnerUuid(): string
    {
        return $this->ownerUuid;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @return array
     */
    public function getRoles(): array
    {
        return $this->roles;
    }

    /**
     * @return ClientDataDivisionInterface[]
     */
    public function getDivisions(): array
    {
        return $this->divisions;
    }

    /**
     * @return ClientDataDivisionInterface
     */
    public function getCurrentDivisionUuid(): ClientDataDivisionInterface
    {
        return $this->currentDivisionUuid;
    }

    /**
     * @return ClientDataOwnerInterface
     */
    public function getClientDataOwner(): ClientDataOwnerInterface
    {
        return $this->clientDataOwner;
    }

    public function getOwner(): ClientDataOwnerInterface
    {
        return $this->clientDataOwner;
    }
}
