<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\CoreBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\MyIsset\CoreBundle\Entity\Division;
use IssetBV\MyIsset\CoreBundle\Repository\Exception\DivisionNotFound;

class DivisionRepository extends EntityRepository
{
    /**
     * @param string $uuid
     *
     * @throws DivisionNotFound
     *
     * @return Division
     */
    public function fetchByUUID(string $uuid): Division
    {
        $division = $this->findOneBy(['uuid' => $uuid]);
        /* @var Division $division */
        if (null === $division || !($division instanceof Division)) {
            throw new DivisionNotFound('No division found for uuid: ' . $uuid);
        }

        return $division;
    }
}
