<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\CoreBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\MyIsset\CoreBundle\Entity\Company;
use IssetBV\MyIsset\CoreBundle\Repository\Exception\CompanyNotFound;

class CompanyRepository extends EntityRepository
{
    /**
     * @param string $uuid
     *
     * @throws CompanyNotFound
     *
     * @return Company
     */
    public function fetchByUUID(string $uuid): Company
    {
        $company = $this->findOneBy(['uuid' => $uuid]);
        /* @var Company $company */
        if (null === $company || !($company instanceof Company)) {
            throw new CompanyNotFound('No company found for uuid: ' . $uuid);
        }

        return $company;
    }
}
