<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\CoreBundle\DependencyInjection;

use IssetBV\MyIsset\CoreBundle\Service\Data\MyIssetUrlProvider;
use IssetBV\MyIsset\CoreBundle\Service\Data\MyIssetUrlProviderInterface;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class MyIssetCoreExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        $baseUrl = $config['myisset_url'];

        $definition = $container->register(MyIssetUrlProvider::class);
        $definition->setAutowired(true);
        $definition->setArgument('$baseUrl', $baseUrl);

        $container->setAlias(MyIssetUrlProviderInterface::class, MyIssetUrlProvider::class);
    }

    public function getAlias(): string
    {
        return 'myisset_core';
    }
}
