<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\CoreBundle\Service\Data;

use Doctrine\Common\Persistence\ObjectManager;
use IssetBV\MyIsset\CoreBundle\Entity\Company;
use IssetBV\MyIsset\CoreBundle\Repository\CompanyRepository;
use IssetBV\MyIsset\CoreBundle\Repository\Exception\CompanyNotFound;
use IssetBV\MyIsset\CoreBundle\Service\Security\ClientDataOwnerInterface;

class CompanyProvider implements CompanyProviderInterface
{
    /**
     * @var CompanyRepository
     */
    private $companyRepository;
    /**
     * @var ObjectManager
     */
    private $objectManager;

    /**
     * CompanyProviderDefault constructor.
     *
     * @param ObjectManager $objectManager
     * @param CompanyRepository $companyRepository
     */
    public function __construct(ObjectManager $objectManager, CompanyRepository $companyRepository)
    {
        $this->companyRepository = $companyRepository;
        $this->objectManager = $objectManager;
    }

    /**
     * @param ClientDataOwnerInterface $owner
     * @return Company
     */
    public function fetchBy(ClientDataOwnerInterface $owner): Company
    {
        try {
            return $this->companyRepository->fetchByUUID($owner->getUuid());
        } catch (CompanyNotFound $e) {
            $company = new Company($owner->getUuid(), $owner->getName());
            $this->objectManager->persist($company);
            $this->objectManager->flush();
            return $company;
        }

    }
}
