<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\CoreBundle\Service\Data;

use Doctrine\Common\Persistence\ObjectManager;
use IssetBV\MyIsset\CoreBundle\Entity\Division;
use IssetBV\MyIsset\CoreBundle\Repository\DivisionRepository;
use IssetBV\MyIsset\CoreBundle\Repository\Exception\DivisionNotFound;
use IssetBV\MyIsset\CoreBundle\Service\Security\UserProviderClientDataDivision;

class DivisionProvider implements DivisionProviderInterface
{
    /**
     * @var ObjectManager
     */
    private $objectManager;
    /**
     * @var DivisionRepository
     */
    private $divisionRepository;

    /**
     * DivisionProviderDefault constructor.
     *
     * @param ObjectManager $objectManager
     * @param DivisionRepository $divisionRepository
     */
    public function __construct(ObjectManager $objectManager, DivisionRepository $divisionRepository)
    {
        $this->objectManager = $objectManager;
        $this->divisionRepository = $divisionRepository;
    }

    public function fetchBy(UserProviderClientDataDivision $divisionData): Division
    {
        try {
            $division = $this->divisionRepository->fetchByUUID($divisionData->getUuid());
            $division->setName($divisionData->getName());
        } catch (DivisionNotFound $e) {
            $division = new Division($divisionData->getUuid(), $divisionData->getName());
            $this->objectManager->persist($division);
        }
        $this->objectManager->flush();

        return $division;
    }
}
