<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\CoreBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\MyIsset\CoreBundle\Entity\User;
use IssetBV\MyIsset\CoreBundle\Service\Data\Exception\UserNotFound;
use IssetBV\MyIsset\CoreBundle\Service\Data\UserProviderInterface;

class UserRepository extends EntityRepository implements UserProviderInterface
{
    public function fetchByUuid(string $uuid): User
    {
        $qb = $this->createQueryBuilder('u');
        $qb->select('u, d');
        $qb->join('u.divisions', 'd');
        $qb->where('u.uuid = :uuid');

        $qb->setParameter('uuid', $uuid);

        $user = $qb->getQuery()->getOneOrNullResult();
        /* @var User $user */
        if (null === $user) {
            throw new UserNotFound('user not found for uuid: ' . $uuid);
        }

        return $user;
    }

    public function fetchById($id): User
    {
        $qb = $this->createQueryBuilder('u');
        $qb->select('u, d');
        $qb->join('u.divisions', 'd');
        $qb->where('u.id = :id');

        $qb->setParameter('id', $id);

        $user = $qb->getQuery()->getOneOrNullResult();
        /* @var User $user */
        if (null === $user) {
            throw new UserNotFound('user not found for id: ' . $id);
        }

        return $user;
    }
}
