<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\CoreBundle\Service\Security\ClientData;

use IssetBV\MyIsset\CoreBundle\Service\Security\UserProviderClientData;
use IssetBV\MyIsset\CoreBundle\Service\Security\UserProviderClientDataDivision;

class ClientData implements UserProviderClientData
{
    /**
     * @var string
     */
    private $uuid;
    /**
     * @var string
     */
    private $ownerUuid;
    /**
     * @var string
     */
    private $name;
    /**
     * @var string
     */
    private $email;
    /**
     * @var array
     */
    private $roles;
    /**
     * @var array
     */
    private $divisions;
    /**
     * @var UserProviderClientDataDivision
     */
    private $currentDivisionUuid;

    /**
     * ClientData constructor.
     *
     * @param string $uuid
     * @param string $ownerUuid
     * @param string $name
     * @param string $email
     * @param array $roles
     * @param array $divisions
     * @param UserProviderClientDataDivision $currentDivisionUuid
     */
    public function __construct(
        string $uuid,
        string $ownerUuid,
        string $name,
        string $email,
        array $roles,
        array $divisions,
        UserProviderClientDataDivision $currentDivisionUuid
    ) {
        $this->uuid = $uuid;
        $this->ownerUuid = $ownerUuid;
        $this->name = $name;
        $this->email = $email;
        $this->roles = $roles;
        $this->divisions = $divisions;
        $this->currentDivisionUuid = $currentDivisionUuid;
    }

    /**
     * @return string
     */
    public function getUuid(): string
    {
        return $this->uuid;
    }

    /**
     * @return string
     */
    public function getOwnerUuid(): string
    {
        return $this->ownerUuid;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @return array
     */
    public function getRoles(): array
    {
        return $this->roles;
    }

    /**
     * @return UserProviderClientDataDivision[]
     */
    public function getDivisions(): array
    {
        return $this->divisions;
    }

    /**
     * @return UserProviderClientDataDivision
     */
    public function getCurrentDivisionUuid(): UserProviderClientDataDivision
    {
        return $this->currentDivisionUuid;
    }
}
