<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\CoreBundle\Service\Data;

use IssetBV\MyIsset\CoreBundle\Entity\User;
use IssetBV\MyIsset\CoreBundle\Service\Data\Exception\UserNotFound;

interface UserProviderInterface
{
    /**
     * @param string $uuid
     *
     * @throws UserNotFound
     *
     * @return User
     */
    public function fetchByUuid(string $uuid): User;

    /**
     * @param $id
     *
     * @throws UserNotFound
     *
     * @return User
     */
    public function fetchById($id): User;
}
