<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\CoreBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\MyIsset\CoreBundle\Entity\User;
use IssetBV\MyIsset\CoreBundle\Service\Data\Exception\UserNotFound;
use IssetBV\MyIsset\CoreBundle\Service\Data\UserProviderInterface;

class UserRepository extends EntityRepository implements UserProviderInterface
{
    /**
     * @param string $uuid
     *
     * @throws UserNotFound
     *
     * @return User
     */
    public function fetchByUuid(string $uuid): User
    {
        $user = $this->findOneBy(['uuid' => $uuid]);
        /* @var User $user */
        if (null === $user) {
            throw new UserNotFound('user not found for uuid: ' . $uuid);
        }

        return $user;
    }

    /**
     * @param $id
     *
     * @throws UserNotFound
     *
     * @return User
     */
    public function fetchById($id): User
    {
        $user = $this->find($id);
        /* @var User $user */
        if (null === $user) {
            throw new UserNotFound('user not found for id: ' . $id);
        }

        return $user;
    }
}
