<?php

declare(strict_types=1);

namespace IssetBV\MyIsset\CoreBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('myisset');

        $rootNode
            ->children()
            ->scalarNode('myisset_url')->defaultValue('https://my.isset.net/')->end()
            ->end();

        return $treeBuilder;
    }
}
