<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\CoreBundle\Service\Data;

use Doctrine\Common\Persistence\ObjectManager;
use IssetBV\MyIsset\CoreBundle\Entity\Company;
use IssetBV\MyIsset\CoreBundle\Repository\CompanyRepository;
use IssetBV\MyIsset\CoreBundle\Repository\Exception\CompanyNotFound;

class CompanyProviderDefault implements CompanyProvider
{

    /**
     * @var CompanyRepository
     */
    private $companyRepository;
    /**
     * @var ObjectManager
     */
    private $objectManager;

    /**
     * CompanyProviderDefault constructor.
     * @param ObjectManager $objectManager
     * @param CompanyRepository $companyRepository
     */
    public function __construct(ObjectManager $objectManager, CompanyRepository $companyRepository)
    {
        $this->companyRepository = $companyRepository;
        $this->objectManager = $objectManager;
    }

    /**
     * @param string $uuid
     * @return Company
     */
    public function fetchBy(string $uuid): Company
    {
        try {
            $company = $this->companyRepository->fetchByUUID($uuid);
        } catch (CompanyNotFound $e) {
            $company = new Company($uuid);
            $this->objectManager->persist($company);
            $this->objectManager->flush($company);
        }
        return $company;
    }
}