<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\CoreBundle\Service\Client\Guzzle;

use IssetBV\MyIsset\CoreBundle\Service\Client\Core\RequestException;
use GuzzleHttp\Exception\RequestException as GuzzleRequestException;

class GuzzleClientRequestException extends RequestException
{

    /**
     * @var GuzzleRequestException
     */
    private $exception;

    public function __construct(GuzzleRequestException $exception)
    {
        parent::__construct($exception->getMessage(), $exception->getCode(), $exception);
        $this->exception = $exception;
    }

    public function getBody()
    {
        return $this->exception->getResponse()->getBody()->getContents();
    }

    public function getHttpCode()
    {
        return $this->exception->getResponse()->getStatusCode();
    }
}