<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\CoreBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\MyIsset\CoreBundle\Entity\Division;
use IssetBV\MyIsset\CoreBundle\Repository\Exception\DivisionNotFound;

class DivisionRepository extends EntityRepository
{

    /**
     * @param $uuid
     * @return Division
     * @throws \IssetBV\MyIsset\CoreBundle\Repository\Exception\DivisionNotFound
     */
    public function fetchByUUID($uuid): Division
    {
        $return = $this->findOneBy(['uuid' => $uuid]);
        if ($return === null) {
            throw new DivisionNotFound();
        }
        return $return;
    }
}