<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\CoreBundle\Service\Security;

use IssetBV\MyIsset\CoreBundle\Entity\User as UserEntity;
use Serializable;
use Symfony\Component\Security\Core\User\UserInterface;

class User implements UserInterface, Serializable
{

    /**
     * @var UserEntity
     */
    private $user;

    /**
     * @var UserProviderClientDataDivision
     */
    private $currentDivision;

    /**
     * @var string
     */
    private $userToken;

    /**
     * @var int
     */
    private $entityId;

    /**
     * OAuthUser constructor.
     * @param UserEntity $user
     * @param UserProviderClientDataDivision|string $currentDivision
     * @param string $userToken
     */
    public function __construct(UserEntity $user, UserProviderClientDataDivision $currentDivision, string $userToken)
    {
        $this->setUser($user);
        $this->currentDivision = $currentDivision;
        $this->userToken = $userToken;
    }

    /**
     * @return string
     */
    public function serialize()
    {
        $data = array(
            $this->entityId,
            $this->currentDivision,
            $this->userToken
        );
        return serialize($data);
    }

    /**
     * @param string $serialized
     * {@inheritdoc}
     */
    public function unserialize($serialized)
    {
        list ($this->entityId, $this->currentDivision, $this->userToken) = unserialize($serialized);
    }

    /**
     * @return array
     */
    public function getRoles()
    {
        return $this->user->getRoles();
    }

    /**
     * {@inheritdoc}
     */
    public function getPassword()
    {
    }

    /**
     * {@inheritdoc}
     */
    public function getSalt()
    {
    }

    /**
     * {@inheritdoc}
     */
    public function getUsername()
    {
        return $this->user->getName();
    }

    /**
     * {@inheritdoc}
     */
    public function eraseCredentials()
    {
    }

    /**
     * @return UserEntity
     */
    public function getUser(): UserEntity
    {
        return $this->user;
    }

    /**
     * @return UserProviderClientDataDivision
     */
    public function getCurrentDivision(): UserProviderClientDataDivision
    {
        return $this->currentDivision;
    }

    /**
     * @return mixed
     */
    public function getUserToken()
    {
        return $this->userToken;
    }

    /**
     * @return mixed
     */
    public function getEntityId()
    {
        return $this->entityId;
    }

    /**
     * @param UserEntity $user
     */
    public function setUser(UserEntity $user)
    {
        $this->user = $user;
        $this->entityId = $user->getId();
    }

}