<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\CoreBundle\Service\Security\ClientData;

use IssetBV\MyIsset\CoreBundle\Service\Security\UserProviderClientDataDivision;

class ClientDataDivision implements UserProviderClientDataDivision
{

    /**
     * @var string
     */
    private $uuid;
    /**
     * @var string
     */
    private $name;

    /**
     * ClientDataDivision constructor.
     * @param string $uuid
     * @param string $name
     */
    public function __construct(string $uuid, string $name)
    {
        $this->uuid = $uuid;
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getUuid(): string
    {
        return $this->uuid;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

}