<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\CoreBundle\Service\Data;

use IssetBV\MyIsset\CoreBundle\Entity\User;
use IssetBV\MyIsset\CoreBundle\Service\Data\Exception\UserNotFound;

interface UserProvider
{

    /**
     * @param string $uuid
     * @return User
     * @throws UserNotFound
     */
    public function fetchByUuid(string $uuid): User;

    /**
     * @param $id
     * @return User
     * @throws UserNotFound
     */
    public function fetchById($id): User;
}