<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\CoreBundle\Service\Data;

class MyIssetDefault implements MyIsset
{

    /**
     * @var string
     */
    private $baseUrl;

    /**
     * MyIssetDefault constructor.
     * @param string $baseUrl
     */
    public function __construct(string $baseUrl)
    {
        $this->baseUrl = rtrim($baseUrl, '/') . '/';
    }

    /**
     * @return string
     */
    public function getBaseUrl(): string
    {
        return $this->baseUrl;
    }

    /**
     * @param string $loginToken
     * @param string $view
     * @param string $returnUrl
     * @return string
     */
    public function getLoginUrl(string $loginToken, string $view, string $returnUrl): string
    {
        return sprintf('%soauth/login?login_token=%s&view=%s&return_url=%s', $this->baseUrl, urlencode($loginToken), urlencode($view),
            urlencode($returnUrl));
    }

    /**
     * @param $returnUrl
     * @return string
     */
    public function getLogoutUrl($returnUrl): string
    {
        return sprintf('%soauth/logout?return_url=%s', $this->baseUrl, urlencode($returnUrl));
    }
}