<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\CoreBundle\Service\Client\Guzzle;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;

class GuzzleClient implements \IssetBV\MyIsset\CoreBundle\Service\Client\Core\Client
{

    /**
     * @var Client
     */
    private $client;

    /**
     * GuzzleClient constructor.
     * @param string $baseUrl
     */
    public function __construct(string $baseUrl)
    {
        $this->client = new Client([
            'base_uri' => rtrim($baseUrl, '/') . '/',
        ]);
    }

    /**
     * @param RequestInterface $request
     * @return ResponseInterface
     * @throws \IssetBV\MyIsset\CoreBundle\Service\Client\Guzzle\GuzzleClientRequestException
     */
    public function call(RequestInterface $request): ResponseInterface
    {
        try {
            return $this->client->send($request);
        } catch (RequestException $e) {
            throw new GuzzleClientRequestException($e);
        }
    }
}