<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\CoreBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\MyIsset\CoreBundle\Entity\User;
use IssetBV\MyIsset\CoreBundle\Service\Data\Exception\UserNotFound;
use IssetBV\MyIsset\CoreBundle\Service\Data\UserProvider;

class UserRepository extends EntityRepository implements UserProvider
{

    public function fetchByUuid(string $uuid): User
    {
        $return = $this->findOneBy(['uuid' => $uuid]);
        if ($return === null) {
            throw new UserNotFound();
        }
        return $return;
    }

    public function fetchById($id): User
    {
        $return = $this->find($id);
        if ($return === null) {
            throw new UserNotFound();
        }
        return $return;
    }
}