<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\CoreBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\MyIsset\CoreBundle\Entity\Company;
use IssetBV\MyIsset\CoreBundle\Repository\Exception\CompanyNotFound;

class CompanyRepository extends EntityRepository
{

    /**
     * @param $uuid
     * @return Company
     * @throws \IssetBV\MyIsset\CoreBundle\Repository\Exception\CompanyNotFound
     */
    public function fetchByUUID($uuid): Company
    {
        $return = $this->findOneBy(['uuid' => $uuid]);
        if ($return === null) {
            throw new CompanyNotFound();
        }
        return $return;
    }
}
