<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\CoreBundle\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;
use IssetBV\MyIsset\CoreBundle\Service\Security\UserProviderClientDataDivision;

/**
 * @ORM\Entity(repositoryClass="IssetBV\MyIsset\CoreBundle\Repository\DivisionRepository")
 * @ORM\Table(name="myisset_divisions")
 */
class Division implements UserProviderClientDataDivision
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     * @ORM\Column(name="uuid", type="string", nullable=false, unique=true)
     */
    private $uuid;

    /**
     * @var string
     * @ORM\Column(name="name", type="string", nullable=false)
     */
    private $name;

    /**
     * @var DateTime
     * @ORM\Column(name="date_created", type="datetime", nullable=false)
     */
    private $dateCreated;

    /**
     * Division constructor.
     * @param string $uuid
     * @param string $name
     */
    public function __construct(string $uuid, string $name)
    {
        $this->uuid = $uuid;
        $this->dateCreated = new DateTime();
        $this->name = $name;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getUuid(): string
    {
        return $this->uuid;
    }

    /**
     * @return DateTime
     */
    public function getDateCreated(): DateTime
    {
        return $this->dateCreated;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name)
    {
        $this->name = $name;
    }

}