<?php
declare(strict_types = 1);

namespace IssetBV\MyIsset\CoreBundle\Entity;

use DateTime;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="IssetBV\MyIsset\CoreBundle\Repository\CompanyRepository")
 * @ORM\Table(name="myisset_companies")
 */
class Company
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     * @ORM\Column(name="uuid", type="string", nullable=false, unique=true)
     */
    private $uuid;

    /**
     * @var DateTime
     * @ORM\Column(name="date_created", type="datetime", nullable=false)
     */
    private $dateCreated;

    public function __construct($uuid)
    {
        $this->uuid = $uuid;
        $this->dateCreated = new DateTime();
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getUuid(): string
    {
        return $this->uuid;
    }

    /**
     * @return DateTime
     */
    public function getDateCreated(): DateTime
    {
        return $this->dateCreated;
    }

}